#!/usr/bin/env bash


driverName="stor.csi.k8s.io"
driverNamespace="default"
iscsiOnHost="false"
snapshotCRDs="false"

for arg in "$@"
do
    case $arg in
        --include-snapshot-crd)
        snapshotCRDs="true"
        shift
        ;;
        --driver-name=*)
        driverName="${arg#*=}"
        shift
        ;;
        --driver-namespace=*)
        driverNamespace="${arg#*=}"
        shift
        ;;
        --iscsi-on-host)
        iscsiOnHost="true"
        shift
        ;;
        *)
        echo "Unknown option: $arg"
        exit 1
        ;;
    esac
done

tmpDir="./tmp-${driverNamespace}"

if [ "$driverNamespace" = "" ]; then
    echo "Error: Value '' at 'driver-namespace' failed to satisfy constraint: Argument must not be ''."
    exit 1
fi
if [ "$driverName" = "" ]; then
    echo "Error: Value '' at 'driver-name' failed to satisfy constraint: Argument must not be ''."
    exit 1
fi

setup_csi_files() {
    local snapshotCRDs=$1
    local iscsiOnHost=$2
    local driverNamespace=$3
    local driverName=$4

    if [ -d $tmpDir ]; then
        rm -rf "$tmpDir"/*yaml
    else
        mkdir -p $tmpDir
    fi

    cp -f ./csi-plugin-conf/csi-configMap.yaml $tmpDir
    cp -f ./csi-plugin-conf/csi-secret-decrypt.yaml $tmpDir
    cp -f ./csi-plugin-conf/csi-secret.yaml $tmpDir
    cp -f ./csi-storplugin-controller-snapshot.yaml $tmpDir
    cp -f ./csi-storplugin-controller.yaml $tmpDir
    cp -f ./csi-storplugin-rbac-snapshot.yaml $tmpDir
    cp -f ./csi-storplugin-rbac.yaml $tmpDir
    cp -f ./csi-snapshot-updater.yaml $tmpDir
    cp -f ./csi-snapshot-updater-rbac.yaml $tmpDir

    if [ "$snapshotCRDs" = "true" ]; then
        cp -f ./snapshot-crds/* $tmpDir
    fi
    if [ "$iscsiOnHost" = "true" ]; then
        cp -f ./csi-plugin-conf/csi-cm-command.yaml $tmpDir
        cp -f ./csi-storplugin-node-iscsi-on-host.yaml $tmpDir
    else
        cp -f ./csi-storplugin-node.yaml $tmpDir
    fi

    local driverNameSuffix=""
    if [ "$driverNamespace" != "default" ]; then
        driverNameSuffix="-$driverNamespace"
    fi

    K8S_VERSION=$(kubectl version --short 2>&1 | grep -i server | awk '{print $3}' | cut -d. -f1,2)

    if [[ "$K8S_VERSION" > "v1.21" ]] || [[ "$K8S_VERSION" == "v1.21" ]]; then
        batchApiVersion="v1"
    else
        batchApiVersion="v1beta1"
    fi

    for file in "$tmpDir"/*; do
        if [ -d "$file" ]; then
            continue
        else
            sed -i "s/@DRIVER_NAMESPACE_SUFFIX@/$driverNameSuffix/g" "$file"
            sed -i "s/@DRIVER_NAMESPACE@/$driverNamespace/g" "$file"
            sed -i "s/@DRIVER_NAME@/$driverName/g" "$file"
            sed -i "s/@BATCH_API_VERSION@/$batchApiVersion/g" "$file"
        fi
    done
}

setup_csi_files $snapshotCRDs $iscsiOnHost $driverNamespace $driverName

function apply_dir(){
    local dir_path="$1"
    for file in "$dir_path"/*; do
        suffix="${file##*.}"
        if [ "$suffix" = "yaml" ]; then
            echo "  [do] kubectl delete -f $1"/"$file"
            kubectl delete -f "$file"
        fi
    done
}

echo -e "start undeployiing......"

apply_dir $tmpDir
rm -rf $tmpDir
if [ "$iscsiOnHost" = "false" ]; then
    kubectl delete configmap stor-multipath-conf -n $driverNamespace
fi
echo -e "end undeploy yaml !!!"