from ctyun.util.utils import append_dq, append_comma_dq


class Request(object):
    def json_string(self):
        pass


class CreateTrailRequest(Request):
    name = None
    s3BucketName = None
    s3KeyPrefix = None

    def json_string(self):
        json = "{"

        if self.name is not None:
            json += append_dq("Name") + ":" + append_dq(self.name)
        if self.s3BucketName is not None:
            json += append_comma_dq("S3BucketName") + ":" + append_dq(self.s3BucketName)

        if self.s3KeyPrefix is not None:
            json += append_comma_dq("S3KeyPrefix") + ":" + append_dq(self.s3KeyPrefix)

        json += "}"
        return json


class DeleteTrailRequest(Request):
    name = None

    def json_string(self):
        json = "{"

        if self.name is not None:
            json += append_dq("Name") + ":" + append_dq(self.name)

        json += "}"
        return json


class DescribeTrailsRequest(Request):
    name_list = []

    def json_string(self):
        if self.name_list is None or len(self.name_list) < 1:
            return "{}"

        first = True
        json = "{"
        json += append_dq("TrailNameList") + ":"

        json += "["
        for name in self.name_list:
            if first:
                first = False
                json += append_dq(name)
            else:
                json += append_comma_dq(name)
        json += "]"

        json += "}"
        return json


class GetTrailStatusRequest(Request):
    name = None

    def json_string(self):
        json = "{"

        if self.name is not None:
            json += append_dq("Name") + ":" + append_dq(self.name)

        json += "}"
        return json


class EventSelect(object):
    read_write_type = 'All'


class PutEventSelectorsRequest(Request):
    trail_name = None
    selector_list = []

    def check_req(self):
        if self.trail_name is None or len(self.trail_name) < 1:
            raise Exception('empty trail name')
        if self.selector_list is None or len(self.selector_list) < 1:
            raise Exception('empty selector list')
        else:
            for selector in self.selector_list:
                if selector.read_write_type is None or len(selector.read_write_type) < 1:
                    raise Exception('empty type')

    def json_string(self):
        json = "{"
        if self.trail_name is None or len(self.trail_name) < 1:
            t_name = ' '
        else:
            t_name = self.trail_name
        json += append_dq("TrailName") + ":" + append_dq(t_name)
        json += append_comma_dq("EventSelectors") + ":[{"

        if self.selector_list is None or len(self.selector_list) < 1:
            json += ""
        else:
            first = True

            for selector in self.selector_list:
                if selector.read_write_type is None or len(selector.read_write_type) < 1:
                    rw = ' '
                else:
                    rw = selector.read_write_type
                if first:
                    first = False
                    json += append_dq("ReadWriteType") + ":" + append_dq(rw)
                else:
                    json += append_comma_dq("ReadWriteType") + ":" + append_dq(rw)

        json += "}]"

        json += "}"
        return json


class GetEventSelectorsRequest(Request):
    trail_name = None

    def json_string(self):
        json = "{"

        if self.trail_name is not None:
            json += append_dq("TrailName") + ":" + append_dq(self.trail_name)

        json += "}"
        return json


class UpdateTrailRequest(Request):
    name = None
    s3BucketName = None
    s3KeyPrefix = None

    def json_string(self):
        json = "{"

        if self.name is not None:
            json += append_dq("Name") + ":" + append_dq(self.name)
        if self.s3BucketName is not None:
            json += append_comma_dq("S3BucketName") + ":" + append_dq(self.s3BucketName)

        if self.s3KeyPrefix is not None:
            json += append_comma_dq("S3KeyPrefix") + ":" + append_dq(self.s3KeyPrefix)

        json += "}"
        return json


class StartLoggingRequest(Request):
    name = None

    def json_string(self):
        json = "{"

        if self.name is not None:
            json += append_dq("Name") + ":" + append_dq(self.name)

        json += "}"
        return json


class StopLoggingRequest(Request):
    name = None

    def json_string(self):
        json = "{"

        if self.name is not None:
            json += append_dq("Name") + ":" + append_dq(self.name)

        json += "}"
        return json


class LookupAttribute:
    attribute_key = None
    attribute_value = None


class LookupEventsRequest(Request):
    start_time = None
    end_time = None
    max_results = None
    next_token = None

    lookup_attribute_list = None

    def json_string(self):
        json = "{"

        if self.start_time is not None:
            json += append_dq("StartTime") + ":" + append_dq(self.start_time)

        if self.end_time is not None:
            json += append_comma_dq("EndTime") + ":" + append_dq(self.end_time)

        if self.lookup_attribute_list is None or len(self.lookup_attribute_list) < 1:
            json += ""
        else:
            json += append_comma_dq("LookupAttributes") + ":[{"
            first = True

            for attribute in self.lookup_attribute_list:
                if first:
                    first = False
                    json += append_dq("AttributeKey") + ":" + append_dq(attribute.attribute_key)
                else:
                    json += append_comma_dq("AttributeKey") + ":" + append_dq(attribute.attribute_key)

                json += append_comma_dq("AttributeValue") + ":" + append_dq(attribute.attribute_value)

            json += "}]"

        if self.max_results is not None:
            json += append_comma_dq("MaxResults") + ":" + append_dq(self.max_results)

        if self.next_token is not None:
            json += append_comma_dq("NextToken") + ":" + append_dq(self.next_token)

        json += "}"
        return json
