from ctyun.result import Result
from ctyun.result import ResponseHeader


class CreateTrailResult(Result):
    Name = None
    S3BucketName = None
    S3KeyPrefix = None
    TrailARN = None

    OBJ_TEMPLATE = (
            "CreateTrailResult: \n"
            + " Name: {Name}, "
            + " S3BucketName: {S3BucketName}, "
            + " S3KeyPrefix: {S3KeyPrefix}, "
            + " TrailARN: {TrailARN} "
    )

    def __init__(self, d={}):
        self.__dict__ = d

    def to_string(self):
        obj = self.OBJ_TEMPLATE.format(
            Name=self.Name,
            S3BucketName=self.S3BucketName,
            S3KeyPrefix=self.S3KeyPrefix,
            TrailARN=self.TrailARN
        )
        return obj


class DeleteTrailResult(Result):
    OBJ_TEMPLATE = (
        "DeleteTrailResult: ok\n"
    )

    def __init__(self, d={}):
        self.__dict__ = d

    def to_string(self):
        obj = self.OBJ_TEMPLATE.format(
        )
        return obj


class DescribeTrailsResult(Result):
    trailList = []

    OBJ_TEMPLATE = (
            " Name: {Name}, "
            + " S3BucketName: {S3BucketName}, "
            + " S3KeyPrefix: {S3KeyPrefix}, "
            + " TrailARN: {TrailARN} "
    )

    def __init__(self, d={}):
        self.__dict__ = d

    def to_string(self):
        obj = "DescribeTrails Result:\n"
        ii = 0
        for describe in self.trailList:
            ii = ii + 1
            obj += "\nTrail " + str(ii) + ":"
            obj += self.OBJ_TEMPLATE.format(
                Name=describe.Name,
                S3BucketName=describe.S3BucketName,
                S3KeyPrefix=describe.S3KeyPrefix,
                TrailARN=describe.TrailARN
            )

        return obj


class GetTrailStatusResult(Result):
    IsLogging = None
    LatestDeliveryTime = None
    StartLoggingTime = None
    StopLoggingTime = None

    OBJ_TEMPLATE = (
            "GetTrailStatusResult: \n"
            + " IsLogging: {IsLogging}, "
            + " LatestDeliveryTime: {LatestDeliveryTime}, "
            + " StartLoggingTime: {StartLoggingTime}, "
            + " StopLoggingTime: {StopLoggingTime} "
    )

    def __init__(self, d={}):
        self.__dict__ = d

    def to_string(self):
        obj = self.OBJ_TEMPLATE.format(
            IsLogging=self.IsLogging,
            LatestDeliveryTime=self.LatestDeliveryTime,
            StartLoggingTime=self.StartLoggingTime,
            StopLoggingTime=self.StopLoggingTime
        )
        return obj


class PutEventSelectorsResult(Result):
    EventSelectors = []
    TrailARN = ""

    OBJ_TEMPLATE = (
        " ReadWriteType: {ReadWriteType}"
    )

    def __init__(self, d={}):
        self.__dict__ = d

    def to_string(self):
        obj = "PutEventSelectors Result:\n"
        obj += "\nEventSelectors:"
        ii = 0
        for selector in self.EventSelectors:
            ii = ii + 1
            obj += "\nSelector " + str(ii) + ":"
            obj += self.OBJ_TEMPLATE.format(
                ReadWriteType=selector.ReadWriteType
            )

        obj += "\nTrailARN:" + self.TrailARN
        return obj


class GetEventSelectorsResult(Result):
    EventSelectors = []
    TrailARN = ""

    OBJ_TEMPLATE = (
        " ReadWriteType: {ReadWriteType}"
    )

    def __init__(self, d={}):
        self.__dict__ = d

    def to_string(self):
        obj = "GetEventSelectors Result:\n"
        obj += "\nEventSelectors:"
        ii = 0
        for selector in self.EventSelectors:
            ii = ii + 1
            obj += "\nSelector " + str(ii) + ":"
            obj += self.OBJ_TEMPLATE.format(
                ReadWriteType=selector.ReadWriteType
            )

        obj += "\nTrailARN:" + self.TrailARN
        return obj


class UpdateTrailResult(Result):
    Name = None
    S3BucketName = None
    S3KeyPrefix = None
    TrailARN = None

    OBJ_TEMPLATE = (
            "UpdateTrail Result: \n"
            + " Name: {Name}, "
            + " S3BucketName: {S3BucketName}, "
            + " S3KeyPrefix: {S3KeyPrefix}, "
            + " TrailARN: {TrailARN} "
    )

    def __init__(self, d={}):
        self.__dict__ = d

    def to_string(self):
        obj = self.OBJ_TEMPLATE.format(
            Name=self.Name,
            S3BucketName=self.S3BucketName,
            S3KeyPrefix=self.S3KeyPrefix,
            TrailARN=self.TrailARN
        )
        return obj


class StartLoggingResult(Result):
    OBJ_TEMPLATE = (
        "StartLogging Result: ok\n"
    )

    def __init__(self, d={}):
        self.__dict__ = d

    def to_string(self):
        obj = self.OBJ_TEMPLATE.format(
        )
        return obj


class StopLoggingResult(Result):
    OBJ_TEMPLATE = (
        "StopLogging Result: ok\n"
    )

    def __init__(self, d={}):
        self.__dict__ = d

    def to_string(self):
        obj = self.OBJ_TEMPLATE.format(
        )
        return obj


class CloudTrailEvent:
    OBJ_TEMPLATE = (
            "CloudTrailEvent: "
            + " index: {index}, "
            + " eventId: {eventId}, "
            + " eventVersion: {eventVersion}, "
            + " eventSource: {eventSource}, "
            + " requestParameters: {requestParameters}, "
            + " userAgent: {userAgent} "
            + " readOnly: {readOnly} "
            + " userIdentity: {userIdentity}, "
            + " eventType: {eventType}, "
            + " serviceName: {serviceName}, "
            + " sourceIp: {sourceIp}, "
            + " requestId: {requestId} "
            + " requestURL: {requestURL}, "
            + " eventTime: {eventTime}, "
            + " eventName: {eventName}, "
            + " requestRegion: {requestRegion}, "
            + " managementEvent: {eventTime} "
    )

    def __init__(self, index=None, event_id=None, event_version=None, event_source=None, request_parameters=None,
                 user_agent=None,
                 read_only=None, user_identity=None, event_type=None, service_name=None, source_ip=None,
                 request_id=None,
                 request_url=None, event_time=None, event_name=None, request_region=None, management_event=None):
        self.index = index
        self.event_id = event_id
        self.event_version = event_version
        self.event_source = event_source
        self.request_parameters = request_parameters
        self.user_agent = user_agent
        self.read_only = read_only
        self.user_identity = user_identity
        self.event_type = event_type
        self.service_name = service_name
        self.source_ip = source_ip
        self.request_id = request_id
        self.request_url = request_url
        self.event_time = event_time
        self.event_name = event_name
        self.request_region = request_region
        self.management_event = management_event

    def to_string(self):
        obj = self.OBJ_TEMPLATE.format(
            index=self.index,
            eventId=self.event_id,
            eventVersion=self.event_version,
            eventSource=self.event_source,
            requestParameters=self.request_parameters,
            userAgent=self.user_agent,
            readOnly=self.read_only,
            userIdentity=self.user_identity,
            eventType=self.event_type,
            serviceName=self.service_name,
            sourceIp=self.source_ip,
            requestId=self.request_id,
            requestURL=self.request_url,
            eventTime=self.event_time,
            eventName=self.event_name,
            requestRegion=self.request_region,
            managementEvent=self.management_event
        )
        return obj

    def get_event_id(self):
        return self.event_id

    def get_event_version(self):
        return self.event_version

    def get_event_source(self):
        return self.event_source

    def get_request_parameters(self):
        return self.request_parameters

    def get_user_agent(self):
        return self.user_agent

    def get_user_identity(self):
        return self.user_identity

    def get_event_type(self):
        return self.event_type

    def get_service_name(self):
        return self.service_name

    def get_source_ip(self):
        return self.source_ip

    def get_request_id(self):
        return self.request_id

    def get_request_url(self):
        return self.request_url

    def get_event_time(self):
        return self.event_time

    def get_event_name(self):
        return self.event_name

    def get_request_region(self):
        return self.request_region

    def get_management_event(self):
        return self.management_event


class LookupEventsResult(Result):

    def __init__(self, d={}):
        self.mydict = d
        self.my_next_token = ''
        self.my_Events = []
        self.p_events = []

    def next_token(self):
        return self.my_next_token

    def event_count(self):
        return self.my_Events.__len__()

    def parser_result(self):
        if self.mydict.__contains__("NextToken"):
            self.my_next_token = self.mydict["NextToken"]
        if self.mydict.__contains__("Events"):
            self.my_Events = self.mydict["Events"]
            index = 0
            for ev in self.my_Events:
                index = index + 1
                cte = ev["CloudTrailEvent"]
                # print(type(cte))
                eventid = cte["eventId"]
                eventVersion = cte["eventVersion"]
                eventSource = cte["eventSource"]

                requestParameters = cte["requestParameters"]
                userAgent = cte["userAgent"]
                readOnly = cte["readOnly"]
                userIdentity = cte["userIdentity"]
                eventType = cte["eventType"]
                serviceName = cte["serviceName"]
                sourceIp = cte["sourceIp"]
                requestId = cte["requestId"]
                requestURL = cte["requestURL"]
                eventTime = cte["eventTime"]
                eventName = cte["eventName"]
                requestRegion = cte["requestRegion"]
                managementEvent = cte["managementEvent"]
                cloud = CloudTrailEvent(index, eventid, eventVersion, eventSource, requestParameters, userAgent,
                                        readOnly, userIdentity,
                                        eventType, serviceName, sourceIp, requestId, requestURL, eventTime, eventName,
                                        requestRegion, managementEvent)
                # print(cloud)
                self.p_events.append(cloud)

    def get_event(self, index) -> CloudTrailEvent:
        if index < self.p_events.__len__():
            ev = self.p_events[index]
            return ev

    def to_string(self):
        pass
