class BaseStatistics:
    def get_response_storage(self, statistic):
        has_data = statistic.getElementsByTagName("Data").length > 0
        has_standard_ia = statistic.getElementsByTagName("Standard_ia").length > 0

        if has_data and has_standard_ia:
            return "ALL"
        elif has_data:
            return "STANDARD"
        elif has_standard_ia:
            return "STANDARD_IA"
        else:
            return ""

    def get_text(self, node, tag):
        elements = node.getElementsByTagName(tag)
        return elements[0].childNodes[0].data if elements and elements[0].childNodes else '-'

    def get_data(self, node, section, tags):
        data = {}
        section_node = node.getElementsByTagName(section)
        if section_node:
            section_node = section_node[0]
            for tag in tags:
                tag_node = section_node.getElementsByTagName(tag)
                if tag_node and tag_node[0].childNodes:
                    data.update({tag: tag_node[0].childNodes[0].data})
                else:
                    data.update({tag: '-'})
        return data

    def get_data_net(self, node, section, tags):
        data = {}
        nets = ["Internet", "NonInternet"]
        section_node = node.getElementsByTagName(section)
        if section_node:
            section_node = section_node[0]
            for net in nets:
                net_node = section_node.getElementsByTagName(net)
                if net_node:
                    net_node = net_node[0]
                    for tag in tags:
                        tag_node = net_node.getElementsByTagName(tag)
                        if tag_node and tag_node[0].childNodes:
                            data.update({tag + ("Non" if net == "NonInternet" else ""): tag_node[0].childNodes[0].data})
                        else:
                            data.update({tag + ("Non" if net == "NonInternet" else ""): '-'})
        return data

    def get_data_code(self, node, section, tags):
        data = {}
        nets = ["Internet", "NonInternet"]
        codes = ["Get", "Head", "Put", "Post", "Delete", "Others"]
        section_node = node.getElementsByTagName(section)
        if section_node:
            section_node = section_node[0]
            for net in nets:
                net_node = section_node.getElementsByTagName(net)
                if net_node:
                    net_node = net_node[0]
                    for code in codes:
                        code_node = net_node.getElementsByTagName(code)
                        if code_node:
                            code_node = code_node[0]
                            for tag in tags:
                                tag_node = code_node.getElementsByTagName(tag)
                                if tag_node and tag_node[0].childNodes:
                                    data.update({code + tag[-3:] + ("NonInt" if net == "NonInternet" else ""): tag_node[0].childNodes[0].data})
                                else:
                                    data.update({code + tag[-3:] + ("NonInt" if net == "NonInternet" else ""): '-'})
        return data

    def get_data_usage(self, section_node, tags):
        data = {}
        if section_node:
            for tag in tags:
                tag_node = section_node.getElementsByTagName(tag)
                if tag_node and tag_node[0].childNodes:
                    data.update({tag: tag_node[0].childNodes[0].data})
                else:
                    data.update({tag: '-'})
        return data

    def format_message(self, *args, **kwargs):
        raise NotImplementedError("Subclasses should implement this method")

    def select_data(self, storage_class, standard_data, standard_ia_data, keys):
        data_map = {
            "Standard": standard_data,
            "StandardIA": standard_ia_data
        }
        return {key: data_map[storage_class][key] for key in keys}
