from ctyun.man.model.request import Request
import xml.sax
from ctyun.util.utils import XMLHandler
from ctyun.result import Result
from ctyun.result import ResponseHeader
from xml.dom.minidom import parseString


class GetAvailBwRequest(Request):
    def __init__(self, begin_date=None, end_date=None, pools=None):
        self.BeginDate = begin_date
        self.EndDate = end_date
        self.Pools = pools

    def get_params(self):
        params = {"Action": "GetAvailBW"}
        if self.BeginDate is not None:
            params['BeginDate'] = self.BeginDate
        if self.EndDate is not None:
            params['EndDate'] = self.EndDate
        if self.Pools is not None:
            params['Pools'] = self.Pools
        return params


class AvailBWData(object):
    OBJ_TEMPLATE = (
            "\n  Date {Date}"
            + "       AvailableUploadBW: {AvailableUploadBW}, "
            + "       AvailableDownloadBW:{AvailableDownloadBW} "
            + "       NonInternetAvailableUploadBW: {NonInternetAvailableUploadBW}, "
            + "       NonInternetAvailableDownloadBW:{NonInternetAvailableDownloadBW} "
    )

    def __init__(self, xml_data, idx):
        self.idx = idx
        self.Date = xml_data.getElementsByTagName("Date")[0].childNodes[0].data
        self.AvailableUploadBW = xml_data.getElementsByTagName("AvailableUploadBW")[0].childNodes[0].data
        self.AvailableDownloadBW = xml_data.getElementsByTagName("AvailableDownloadBW")[0].childNodes[0].data
        self.NonInternetAvailableUploadBW = \
            xml_data.getElementsByTagName("NonInternetAvailableUploadBW")[0].childNodes[0].data
        self.NonInternetAvailableDownloadBW = \
            xml_data.getElementsByTagName("NonInternetAvailableDownloadBW")[0].childNodes[0].data
        self.msg = self.OBJ_TEMPLATE.format(
            Date=self.Date, AvailableUploadBW=self.AvailableUploadBW, AvailableDownloadBW=self.AvailableDownloadBW,
            NonInternetAvailableUploadBW=self.NonInternetAvailableUploadBW,
            NonInternetAvailableDownloadBW=self.NonInternetAvailableDownloadBW
        )

    def to_string(self):
        return self.msg


class Region(object):
    OBJ_TEMPLATE = (
            "\n Region {order}:"
            + "       Name: {Name}, "
            + "       Data count:{Cnt} "
    )

    def __init__(self, region, order):
        self.Name = None
        self.Cnt = 0
        self.msg = ""
        self.dataList = []
        self.order = order
        self.Name = region.getElementsByTagName("Name")[0].childNodes[0].data
        datas = region.getElementsByTagName("Data")
        idx = 0
        for xml_data in datas:
            data = AvailBWData(xml_data, idx)
            self.dataList.append(data)
            idx = idx + 1
        self.Cnt = idx

        self.msg = self.OBJ_TEMPLATE.format(
            order=self.order,
            Name=self.Name,
            Cnt=self.Cnt,
        )

    def to_string(self):
        i = 0
        str = self.msg
        while i < self.dataList.__len__():
            str += self.dataList[i].to_string()
            i = i + 1
        return str

    def get_data(self, index) -> AvailBWData or None:
        if (index < self.dataList.__len__()) & (index >= 0):
            return self.dataList[index]
        else:
            return None

    def get_data_cnt(self):
        return self.dataList.__len__()


class GetAvailBWResult(Result):
    OBJ_TEMPLATE = (
            "Get Bandwidth Result: \n"
            + " UserName: {UserName}, "
            + " RegionCount: {RegionCount} "
            + " \nRegions: {regionList_msg} "
    )

    def set_header(self, header):
        self.header = header

    def get_header(self):
        return self.header

    def __init__(self):
        self.UserName = None
        self.RegionCount = 0
        self.RegionList = []
        self.Regions = []
        self.xmlResp = ""
        self.msg = ""
        self.header = ResponseHeader()

    def parse(self, xml_response):
        xh = XMLHandler()
        xml.sax.parseString(xml_response, xh)
        self.xmlResp = xml_response
        result = xh.getDict()
        self.UserName = result['UserName']
        region_list_msg = ""
        self.RegionList = parseString(xml_response).documentElement.getElementsByTagName("Region")
        ii = 0
        for region in self.RegionList:
            one_region = Region(region, ii)
            self.Regions.append(one_region)
            ii = ii + 1
            region_list_msg += one_region.to_string()
        self.RegionCount = ii
        self.msg = self.OBJ_TEMPLATE.format(
            UserName=self.UserName,
            RegionCount=self.RegionCount,
            regionList_msg=region_list_msg
        )

    def get_xml_resp(self):
        return self.xmlResp

    def to_string(self):
        return self.msg

    def get_region(self, index) -> Region or None:
        if (index < self.Regions.__len__()) & (index >= 0):
            return self.Regions[index]
        else:
            return None
