from ctyun.man.model.request import Request
import xml.sax
from ctyun.util.utils import XMLHandler
from ctyun.result import Result
from ctyun.result import ResponseHeader
from xml.dom.minidom import parseString
from ctyun.man.model.baseStatistics import BaseStatistics


class GetConcurrentConnectionRequest(Request):
    def __init__(self, BeginDate=None, EndDate=None, Bucket=None, Region=None, Freq=None, InternetType=None):
        self.BeginDate = BeginDate
        self.EndDate = EndDate
        self.Bucket = Bucket
        self.Region = Region
        self.Freq = Freq
        self.InternetType = InternetType

    def get_params(self):
        params = {"Action": "GetConcurrentConnection"}
        if self.BeginDate is not None:
            params['BeginDate'] = self.BeginDate
        if self.EndDate is not None:
            params['EndDate'] = self.EndDate
        if self.Bucket is not None:
            params['Bucket'] = self.Bucket
        if self.Region is not None:
            params['Region'] = self.Region
        if self.Freq is not None:
            params['Freq'] = self.Freq
        if self.InternetType is not None:
            params['InternetType'] = self.InternetType

        return params


class ConcurrentConnectionStatistics(BaseStatistics):
    OBJ_TEMPLATE = (
            "\n    Concurrent Connection Statistic {order}: \n"
            + "       Date: {date}, "
            + "       Data:  "
            + "       InternetConnection: {InternetConnection}, "
            + "       NonInternetConnection: {NonInternetConnection} "
    )
    CONCURRENT_CONNECTION_KEYS = ["InternetConnection", "NonInternetConnection"]

    def __init__(self, statistic, order):
        super().__init__()
        self.date = self.get_text(statistic, "Date")
        self.data = self.get_data(statistic, "Data", self.CONCURRENT_CONNECTION_KEYS)
        self.msg = self.format_message(statistic, order)

    def format_message(self, statistic, order):
        message_parts = [self.OBJ_TEMPLATE.format(
            order=order,
            date=self.date,
            **{key: self.data.get(key, '-') for key in self.CONCURRENT_CONNECTION_KEYS}
        )]
        return ''.join(message_parts)

    def to_string(self):
        return self.msg


class GetConcurrentConnectionResult(Result):
    OBJ_TEMPLATE = (
            "Get Concurrent Connection Result: \n"
            + " Account: {Account}, "
            + " UserName: {UserName}, "
            + " TimeZone: {TimeZone}, "
            + " Freq: {Freq} "
            + " BucketName: {BucketName} "
            + " RegionName: {RegionName} "
            + " InternetType: {InternetType} "
            + " \n Statistics: {Statistics} "
    )

    Account = None
    UserName = None
    TimeZone = None
    Freq = None
    BucketName = None
    RegionName = None
    InternetType = None

    Statistics = []
    xmlResp = ""
    msg = ""
    header = ResponseHeader()

    def set_header(self, header):
        self.header = header

    def get_header(self):
        return self.header

    def __init__(self):
        pass

    def parse(self, xml_response):
        xh = XMLHandler()
        xml.sax.parseString(xml_response, xh)
        self.xmlResp = xml_response
        result = xh.getDict()

        self.Account = result['Account']
        self.UserName = result['UserName']
        self.TimeZone = result['TimeZone']
        self.Freq = result['Freq']

        self.BucketName = result['BucketName']
        self.RegionName = result['RegionName']

        self.InternetType = result['InternetType']

        statistics_msg = ""

        statistics = parseString(xml_response).documentElement.getElementsByTagName("Statistics")
        ii = 0
        for xml_statistic in statistics:
            ii = ii + 1
            statistic = ConcurrentConnectionStatistics(xml_statistic, ii)
            self.Statistics.append(statistic)
            statistics_msg += statistic.to_string()

        self.msg = self.OBJ_TEMPLATE.format(
            Account=self.Account,
            UserName=self.UserName,
            TimeZone=self.TimeZone,
            Freq=self.Freq,
            BucketName=self.BucketName,
            RegionName=self.RegionName,
            InternetType=self.InternetType,
            Statistics=statistics_msg,
        )

    def to_string(self):
        return self.msg

    def get_xml_resp(self):
        return self.xmlResp
