from ctyun.man.model.request import Request
import xml.sax
from ctyun.util.utils import XMLHandler
from ctyun.result import Result
from ctyun.result import ResponseHeader
from xml.dom.minidom import parseString
import datetime


class GetUsageV5Request(Request):
    def __init__(self, date=None, pools=None):
        if date is None:
            self.date = datetime.datetime.now().strftime('%Y-%m-%d')
        else:
            self.date = date
        self.pools = pools

    def get_params(self):
        params = {"Action": "GetUsage"}
        if self.date is not None:
            params['date'] = self.date
        if self.pools is not None:
            params['pools'] = self.pools
        return params


class UsagePool(object):
    OBJ_TEMPLATE = (
        "pool Name: {Name}, Capacity: {Capacity}, Upload: {Upload} "
    )

    def __init__(self, xml_data):
        self.Name = xml_data.getElementsByTagName("Name")[0].childNodes[0].data
        self.Capacity = xml_data.getElementsByTagName("Capacity")[0].childNodes[0].data
        self.Upload = xml_data.getElementsByTagName("Upload")[0].childNodes[0].data
        self.Download = xml_data.getElementsByTagName("Download")[0].childNodes[0].data
        self.GetHeadRequest = xml_data.getElementsByTagName("GetHeadRequest")[0].childNodes[0].data
        self.OtherRequest = xml_data.getElementsByTagName("OtherRequest")[0].childNodes[0].data
        self.InternetUpload = xml_data.getElementsByTagName("InternetUpload")[0].childNodes[0].data
        self.InternetDownload = xml_data.getElementsByTagName("InternetDownload")[0].childNodes[0].data
        self.InternetGetHeadRequest = xml_data.getElementsByTagName("InternetGetHeadRequest")[0].childNodes[0].data
        self.InternetOtherRequest = xml_data.getElementsByTagName("InternetOtherRequest")[0].childNodes[0].data
        self.NonInternetUpload = xml_data.getElementsByTagName("NonInternetUpload")[0].childNodes[0].data
        self.NonInternetDownload = xml_data.getElementsByTagName("NonInternetDownload")[0].childNodes[0].data
        self.NonInternetGetHeadRequest = xml_data.getElementsByTagName("NonInternetGetHeadRequest")[0].childNodes[
            0].data
        self.NonInternetOtherRequest = xml_data.getElementsByTagName("NonInternetOtherRequest")[0].childNodes[0].data
        self.SpamRequest = xml_data.getElementsByTagName("SpamRequest")[0].childNodes[0].data
        self.PornReviewFalse = xml_data.getElementsByTagName("PornReviewFalse")[0].childNodes[0].data
        self.PornReviewTrue = xml_data.getElementsByTagName("PornReviewTrue")[0].childNodes[0].data
        self.msg = self.OBJ_TEMPLATE.format(
            Name=self.Name,
            Capacity=self.Capacity,
            Upload=self.Upload
        )

    def to_str(self):
        return self.msg


class GetUsageV5Result(Result):
    OBJ_TEMPLATE = (
            "Get Usage Result: \n"
            + " UserName: {UserName}, "
            + " \n Date: {Date} "
            + " \n PoolCount: {PoolCount} "
    )

    def set_header(self, header):
        self.header = header

    def get_header(self):
        return self.header

    def __init__(self):
        self.UserName = None
        self.Date = None
        self.poolList = []
        self.pools = []
        self.PoolCount = 0
        self.xmlResp = ""
        self.msg = ""
        self.header = ResponseHeader()

    def parse(self, xml_response):
        xh = XMLHandler()
        xml.sax.parseString(xml_response, xh)
        self.xmlResp = xml_response
        result = xh.getDict()
        self.UserName = result['UserName']
        self.Date = result['Date']
        self.poolList = parseString(xml_response).documentElement.getElementsByTagName("Aggregated")
        ii = 0
        for pool in self.poolList:
            one_pool = UsagePool(pool)
            self.pools.append(one_pool)
            ii = ii + 1
        self.PoolCount = ii
        self.msg = self.OBJ_TEMPLATE.format(
            UserName=self.UserName,
            Date=self.Date,
            PoolCount=self.PoolCount,
        )

    def get_xml_resp(self):
        return self.xmlResp

    def to_string(self):
        return self.msg

    def get_pool(self, index) -> UsagePool or None:
        if (index < self.pools.__len__()) & (index >= 0):
            return self.pools[index]
        else:
            return None
