class ResponseHeader(object):
    response_date = None
    request_id = None
    http_version = "HTTP/1.1"
    server_info = "Ctyun"
    content_length = None
    content_type = None
    status_code = None
    headers = None

    MSG_TEMPLATE = (
            "ResponseHeaderMeta: "
            + "StatusCode: {StatusCode}, "
            + "Response Date: {ResponseDate}, "
            + "RequestId: {RequestId}, "
            + "ContentLength: {ContentLength}, "
            + "ContentType: {ContentType}, "
            + "HttpVersion: {HttpVersion}, "
            + "ServerInfo:  {ServerInfo} "
    )

    def __init__(self, headers=None, status_code=None):

        if headers is None:
            return
        if "Date" in headers:
            self.response_date = headers["Date"]
        if "x-amz-request-id" in headers:
            self.request_id = headers["x-amz-request-id"]
        if "Server" in headers:
            self.server_info = headers["Server"]
        if "Content-Type" in headers:
            self.content_type = headers["Content-Type"]
        if "Content-Length" in headers:
            self.content_length = headers["Content-Length"]
        else:
            self.content_length = 0
        self.status_code = status_code
        self.headers = headers

    def to_string(self):
        if self.headers is None:
            return ""

        msg = self.MSG_TEMPLATE.format(
            HttpVersion=self.http_version,
            ResponseDate=self.response_date,
            RequestId=self.request_id,
            StatusCode=self.status_code,
            ContentLength=self.content_length,
            ContentType=self.content_type,
            ServerInfo=self.server_info,
        )
        return msg


class Result(object):

    def __init__(self, header=None):
        self._header = header

    def set_header(self, header):
        self._header = header

    def get_header(self):
        return self._header

    def to_string(self):
        pass
