class DomainConfig:
    S5SubDomainUpperCase = {"OOS-JS.",  # 江苏
                            "OOS-JS-MG.",
                            "OOS-JS-IAM.",
                            "OOS-BJ2.",  # 北京2
                            "OOS-BJ2-MG.",
                            "OOS-BJ2-IAM.",
                            "OOS-HQ-BJ.",  # 北京
                            "OOS-HQ-BJ-MG.",
                            "OOS-HQ-BJ-IAM.",
                            "OOS-NM2.",  # 内蒙
                            "OOS-NM2-MG.",
                            "OOS-NM2-IAM.",
                            "OOS-SNXA.",  # 西安
                            "OOS-SNXA-MG.",
                            "OOS-SNXA-IAM.",
                            "OOS-HQ-SH.",  # 上海
                            "OOS-HQ-SH-MG.",
                            "OOS-HQ-SH-IAM.",
                            "OOS-HNCS.",  # 长沙
                            "OOS-HNCS-MG.",
                            "OOS-HNCS-IAM.",
                            "OOS-FJ2.",  # 福建
                            "OOS-FJ2-MG.",
                            "OOS-FJ2-IAM.",
                            "OOS-HZ.",  # 杭州
                            "OOS-HZ-MG.",
                            "OOS-HZ-IAM.",
                            "OOS-GZ.",  # 广州
                            "OOS-GZ-MG.",
                            "OOS-GZ-IAM."
                            }

    def is_s5_endpoint(self, endpoint):
        is_server_5 = False
        if endpoint is None:
            return False

        for sub_domain in DomainConfig.S5SubDomainUpperCase:
            if endpoint.upper().find(sub_domain) >= 0:
                is_server_5 = True
                break

        return is_server_5
