#!/usr/bin/env python

"""
distutils/setuptools install script.
"""
import os
import re

from setuptools import setup, find_packages

ROOT = os.path.dirname(__file__)
VERSION_RE = re.compile(r'''__version__ = ['"]([0-9.]+)['"]''')

requires = [
    'jmespath>=0.7.1,<1.0.0',
    'python-dateutil',
    'httpx',
    'urllib3',
    'requests',
    'futures; python_version == "3.3"'
]


def get_version():
    init = open(os.path.join(ROOT, 'oos', '__init__.py')).read()
    return VERSION_RE.search(init).group(1)


def package_files(directory):
    paths = []
    for (path, directories, filenames) in os.walk(directory):
        for filename in filenames:
            if 'svn' not in path:
                paths.append(os.path.join('..', path, filename))
    return paths


oos_data = package_files('oos/data')

ooscore_data = package_files('ooscore/data')

setup(
    name='oos-python-sdk',
    version=get_version(),
    description='The OOS SDK for Python',
    long_description='The OOS SDK for Python',
    author='CTYun Services',
    url='https://www.ctyun.cn',
    scripts=[],
    packages=find_packages(exclude=['tests*']),
    package_data={
        'oos': oos_data,
        'ooscore': ooscore_data
    },
    include_package_data=True,
    install_requires=requires,
    license="Apache License 2.0",
    classifiers=[
        'Development Status :: 6.5 - Production/Stable',
        'Intended Audience :: Developers',
        'Natural Language :: English',
        'License :: OSI Approved :: Apache Software License',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
    ],
)
